package game;

import java.awt.Color;
import java.awt.Graphics;

public class ConveyorBlockSprite extends SolidBlockSprite implements MovingObject {
	
	
	private int speed;
	private char direction;
	
	private CustomImageDataII[] animation;
	
	private int animIndex;
	
	public ConveyorBlockSprite(boolean isResource, int theWidth, int theHeight, int xPosition, int yPosition, boolean passThru,
			PonyPanel thePonyPanel, int theSpeed, char theDirection, String [] resourceNames, Color [] transparentColors, String roomName) {
		super(isResource, resourceNames[0], theWidth, theHeight, xPosition, yPosition, transparentColors[0], passThru, thePonyPanel);
		
		
		speed = theSpeed;
		direction = theDirection;
		
		if(transparentColors == null || resourceNames == null)
			return;
		
		animation = new CustomImageDataII[Math.min(resourceNames.length, transparentColors.length)];
		
		if(resourceNames != null) {
			for(int i = 0; i < resourceNames.length && i < transparentColors.length; i++) {
				animation[i] = CustomImageDataIIRepository.loadImage(resourceNames[i], transparentColors[i], thePonyPanel, theWidth, theHeight, roomName);
						//new CustomImageDataII(resourceNames[i], transparentColors[i], thePonyPanel, theWidth, theHeight);
			}
		}
		
		animIndex = 0;
		
	}
	
	public ConveyorBlockSprite(CustomImageDataII [] images, int theWidth, int theHeight, int xPosition, int yPosition, boolean passThru, 
			int theSpeed, char theDirection) {
		
		super(images[0], theWidth, theHeight, xPosition, yPosition,  passThru);
		
		animation = images;
		animIndex = 0;
		
		speed = theSpeed;
		direction = theDirection;
		
		
		if(animation != null) {
			int aWidth = theWidth;
			int aHeight = theHeight;
			
			for(CustomImageDataII cid : images) {
				if(cid.getDesiredWidth() != aWidth) {
//					CustomImageDataIIRepository.writeToLog("");
//					CustomImageDataIIRepository.writeToLog("^^^^  and there was an image that had a different width than we wanted!  aWidth: " + aWidth + ", actual: " + cid.getDesiredWidth() + ", and the name: " + cid.getFileName());
//					CustomImageDataIIRepository.writeToLog("");
					
//					Thread t = Thread.currentThread();
//					StackTraceElement e[] = t.getStackTrace();
//					
//					for(StackTraceElement an : e) {
//						
//						CustomImageDataIIRepository.writeToLog("it was way ooff all right.  Stack trace: " + an.getClassName() + " : " + an.getMethodName() + ", " + an.getLineNumber());
//						
//					}
//					
//					CustomImageDataIIRepository.writeToLog("");
					
				}
				
//				if(cid.getDesiredHeight() != aHeight) {
//					CustomImageDataIIRepository.writeToLog("");
//					CustomImageDataIIRepository.writeToLog("^^^^  and there was an image that had a different height than we wanted!  aHeight: " + aHeight + ", actual: " + cid.getDesiredHeight() + ", and the name: " + cid.getFileName());
//					CustomImageDataIIRepository.writeToLog("");
//				}
			}
			
		}
		
	}
	
	public void update(PlayerSprite player) {
		
		int moveQty = speed;
		if(direction == 'l')
			moveQty = -moveQty;
		
		if(this.isPlayerCurrentlyOnBlock(player)) {
			player.pushPlayerX(moveQty, this, false);
		}
		
		
		animIndex++;
		if(animIndex >= animation.length)
			animIndex = 0;
	}

	@Override
	public char getDir() {
		return direction;
	}
	
	@Override
	public void draw(Graphics g, PlayerSprite player, int panelWidth, int panelHeight) {
		
//		image.drawObject(g, panelWidth/2 + (this.getxPos() - player.getxPos()) , panelHeight/2 + (this.getyPos() - player.getyPos()));
		animation[animIndex].drawObject(g, panelWidth/2 + (this.getxPos() - player.getxPos()) , panelHeight/2 + (this.getyPos() - player.getyPos()));
		
	}
	
	
}
